﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerMovement : MonoBehaviour {

    public static PlayerMovement instance;

    public Rigidbody2D rb;
    public float speed = 1.5f;

    public bool isAlive;

    bool moveForward = false,
         moveBackward = false,
         move = false;

    void Awake() {
        if (instance == null) {
            instance = this;
        }
        isAlive = true;

        CameraX();
    }

    void Start () {
        rb = GetComponent<Rigidbody2D>();
    }

    void FixedUpdate() {

        float horizontal = Input.GetAxis("Horizontal");

        Move(horizontal);
        MoveForward();
        MoveBackward();
    }

    public void Move(float horizon) {
        rb.velocity = new Vector2(horizon * speed, rb.velocity.y);
        move = true;
    }

    public void MoveForward() {
        if (Input.GetKey(KeyCode.D)) {
            rb.AddForce(transform.right * speed);
            moveForward = true;
            moveBackward = false;
            move = false;
        }
    }

    public void MoveBackward() {
        if (Input.GetKey(KeyCode.A)) {
            rb.AddForce(transform.right * -300f * Time.deltaTime);
            moveBackward = true;
            moveForward = false;
            move = false;
        }
    }


    public float GetPositionX() {
        return transform.position.x;
    }

    void CameraX() {
        CameraScript.offset = (Camera.main.transform.position.x - transform.position.x) - 1f;
    }
}
